
F2()
! The functions F2 to F12 can be called by
!	either the buttons on your keyboard
!		or by a click on the menu entry
!		or by the programm like that:

F2()	! The $ variable populates an array
F3()	! Calculate Factorials
F4()	! Random values, Graph, and display of $VEC
F5()	! Archimedes spiral
F6()	! Logarithmic spiral
F9()	! Quit HicEst
END

FUNCTION F2() ! The $ variable populates an array
    SYSTEM(BackGround=995, FontSize=18)
    DLG(Left=1/4, Wid=1/2, TItle='To step into a FUNCTION: Shift+ENTER', Edit='#explain$', But='OK')
    $VEC(1000) = 0      ! to define the length of $VEC
    $VEC($) = $ ^ 2     ! to check: F1 or a right mouse button click on the item of interest
    DLG(Left=3/4, Wid=1/4, Array=$VEC, SCRoL=20, TItle='nr,$VEC($) = $ ^ 2. Click here. Try menu.')
END

FUNCTION F3() ! Calculate Factorials
    DO
        DLG(NumEdit=$max,SYMbol, NE=$factorial,SYM,BG=0, B="Calculate", XEQ="$factorial=FACTOR()", E='#F3notes', B='Next')
        IF($txtRC == 'Next') EXIT
    ENDDO
END
FUNCTION FACTOR()
    fact = 1              ! initial value to get FACTORIAL(arg)
    fact = $ * fact       ! = 1 x 2 x 3 x ... x $max
    RETURN fact
END

FUNCTION F4() ! Random values, Graph, and display of $VEC
    $max = 100
    $VEC(100) = 0     ! to define the length of $VEC
    $VEC($) = RAN(50, 20)
    DLG(R=2,C=2,AXis=2, TI='Random numbers $VEC as a function of the "number" $', Y=0, TI='30 + RAN(40)')
    LINE(AXis=2, X=$, Y=$VEC($), Symbol='●', Draw=-900)
    DLG(Wid=1/3, Array=$VEC, TIt=',RAN(50) +- 20')
    DLG(Kill=2)
END

FUNCTION F5() ! Archimedes spiral
    $max = 300
    DLG(TI='Archimedes Spiral', R=2,C=3,AXis=1, X=0,MIN=-1,MAX=1,TI='$/$max*COS($/10)', Y=0,MIN=-1,MAX=1,TI='$/$max*SIN($/10)')
    LINE(AX=1, X=COS($/10)*$/$max, Y=SIN($/10)*$/$max, W=3, Draw=900)
END

FUNCTION F6() ! Logarithmic spiral
    $max = 5000
    a = 5
    DLG(TI='Logarithmic Spiral', R=2,C=3,AXis=3, X=0,MIN=-a,MAX=a,TI='LOG($)*COS($/a)', Y=0,MIN=-a,MAX=a,TI='LOG($)*SIN($/a)')
    LINE(AX=3, X=LOG($)*COS($/a), Y=LOG($)*SIN($/a), W=3, Draw=900*$/$max)
END

FUNCTION F9() ! Quit HicEst
    TIME(SLEEP=100) ! sleep 100 msec to allow preceeding function to finish
    MSG(Text='Quit HicEst?', Icon='?')
    SYSTEM(QUIT=1)
END

#explain$
.	This is FUNCTION F2().
.	To get a feeling for the code please play with it.

.	From the MENUBAR you can select these FUNCTIONs:
F2: this FUNCTION: Set $VEC to the squares of 1..1000
F3: get factorial(x)
F4: Random values, Graph, and display of $VEC
F5: Archimedes spiral
F6: Logarithmic spiral and Quit this script.

.	You need to know:
$ is a global loop variable (valid everywhere)
$ is set to 1 at the start of each code line
$ runs from 1 to $max, eg:
.	$max=100       ! with a leading $ its a global variable
.	VEC($max) = 0
.	VEC($) = $ - 1 ! sets VEC(1)=0, ..., VEC(100)=99

.	You may want to know:
$ frees the script from lengthy loops
A variable prefixed with a $ makes it global (valid everywhere)
The comment after the procedure heads of F2..F12 shows as menu-tooltip
#F3notes
You need to know:
.	In DLG() you see
.
.		B="calculate factorial($max)", XEQ="factorial=FACTOR($max)"
.
.		The XEQ option after the Button option will activate
.		the FUNCTION "FACTOR" when the Button is activated.
.		This will calculate factorial($max).
###




